 ; Ŀ
 ;   Catsup - insert a block (upright) on a line, break the line,          
 ;   reposition attributes.                                                
 ;   Copyright 2000, 2010 by Rocket Software Ltd.                          
 ;                                                                         
 ;   Contains the latest version of the attribute repositioner Repat.      
 ; 

 ; Ŀ
 ;   Repat - Rejustify and reposition an attribute.                        
 ;   Arguments: Enam, the attribute ename.                                 
 ;              LorR, the L or R justification text string.                
 ;              Pa, the new position.                                      
 ;   Calls nothing, returns nothing.                                       
 ; 
 (DEFUN REPAT (enam lorr pa / entt)
  (setq entt (entget enam))
 ; Ŀ
 ;   Left.                                                                 
 ; 
  (cond ((= lorr "L")
         (setq entt (subst (cons 10 pa) (assoc 10 entt) entt)) ; insertion
         (setq entt (subst (cons 74 0) (assoc 74 entt) entt))
         (setq entt (subst (cons 50 0) (assoc 50 entt) entt))  ; rotation
         (setq entt (subst (cons 73 0) (assoc 73 entt) entt))  ; bottom just.
         (entmod (subst (cons 72 0) (assoc 72 entt) entt)))
 ; Ŀ
 ;   Right.                                                                
 ; 
        ((= lorr "R")
         (setq entt (subst (cons 11 pa) (assoc 11 entt) entt)) ; insertion
         (setq entt (subst (cons 50 0) (assoc 50 entt) entt))  ; rotation
         (setq entt (subst (cons 74 0) (assoc 74 entt) entt))  ; bottom just.
         (entmod (subst (cons 72 2) (assoc 72 entt) entt)))
 ; Ŀ
 ;   Mid-Left.                                                             
 ; 
        ((= lorr "ML")
         (if (assoc 74 entt)
             (setq entt (subst (cons 74 2) (assoc 74 entt) entt))
             (setq entt (append entt (list (cons 74 2)))))
         (setq entt (subst (cons 72 0) (assoc 72 entt) entt))
         (entmod (subst (cons 50 0) (assoc 50 entt) entt))
         (setq entt (entget enam))
         (entmod (subst (cons 11 pa) (assoc 11 entt) entt)))
 ; Ŀ
 ;   Mid-Right.                                                            
 ; 
        ((= lorr "MR")
         (setq entt (subst (cons 11 pa) (assoc 11 entt) entt)) ; insertion
         (setq entt (subst (cons 50 0) (assoc 50 entt) entt))  ; rotation
         (setq entt (subst (cons 74 2) (assoc 74 entt) entt))  ; middle just.
         (entmod (subst (cons 72 2) (assoc 72 entt) entt))))
 (princ))
 ; Ŀ
 ;   Repat end.                                                            
 ; 

 ; Ŀ
 ;   Pf: find the lwpline, pline, or line segment a point lies on.         
 ;   Takes two arguments: the point and the pline ename.                   
 ;   Returns a list: the number of vertices and the endpoints of the       
 ;   segment containing the point, or the number of vertices and nil.      
 ;   If the entity is a line then the number of vertices is usually 2,     
 ;   other entity types return nil.                                        
 ;   Caution: doesn't check for closed polylines.                          
 ; 
 (DEFUN PF (pa enam / typ entt num vnum entt2 end1 end2 angg pb pint entt1)
  (setq typ (cdr (assoc 0 (setq entt (entget enam)))))
  (cond ((= typ "POLYLINE")
         (setq num 0)
         (while (/= "SEQEND" (cdr (assoc 0 (setq entt2
                                       (entget (setq enam (entnext enam)))))))
                (setq num (1+ num))
                (if (and entt1 entt2 (null pint))
                    (progn
                         (setq end1 (cdr (assoc 10 entt1)))
                         (setq end2 (cdr (assoc 10 entt2)))
                         (setq angg (angle end1 end2))
                         (setq pb (polar pa (+ angg (/ pi 2)) 0.000001))
                         (setq pint (inters end1 end2 pa pb))))
                (if (null pint)
                    (setq entt1 entt2)))
         (if pint
            (list num end1 end2)
            (list num ())))
        ((= typ "LWPOLYLINE")
         (setq vnum (setq num 0))
         (while (setq sub (nth num entt))
                (setq num (1+ num))
                (if (= (car sub) 10)
                    (progn
                         (setq vnum (1+ vnum))
                         (setq end2 (cdr sub))
                         (if (and end1 end2 (null pint))
                             (progn
                                  (setq angg (angle end1 end2))
                                  (setq pb (polar pa (+ angg (/ pi 2))
                                                                     0.000001))
                                  (if (inters end1 end2 pa pb)
                                      (setq pint (list end1 end2)))))
                         (if (null pint) (setq end1 end2)))))
         (cons vnum pint))
        ((= typ "LINE")
         (setq end1 (cdr (assoc 10 entt)))
         (setq end2 (cdr (assoc 11 entt)))
         (setq angg (angle end1 end2))
         (setq pb (polar pa (+ angg (/ pi 2)) 0.000001))
         (setq pint (inters end1 end2 pa pb))
         (if pint
            (list 2 end1 end2)
            (list 2 ())))
        (T nil)))
 ; Ŀ
 ;   Pf end.                                                               
 ; 

 ; Ŀ
 ;   Pomm - find the prompts in a block definition.                        
 ;   Takes one argument, a block name.                                     
 ;   Returns a list of prompt strings.                                     
 ;                                                                         
 ;   Standard Notes: 1. Entnext returns nil after the last entity in a     
 ;                      block definition.                                  
 ;                   2. An empty block has one subentity of type Endblk.   
 ; 
 (DEFUN POMM (namm / entt prom prlis)
  (setq namm (cdr (assoc -2 (tblsearch "block" namm))))
  (while (and namm (setq entt (entget namm)))            ; the whole thing
         (setq namm (entnext namm))                      ; next subentity ename
         (setq prom (cdr (assoc 3 entt)))
         (if prom (setq prlis (append prlis (list prom)))))
 prlis)
 ; Ŀ
 ;   pomm end.                                                              
 ; 

 ; Ŀ
 ;   Subroutine Ptor - get either a point or a set of inputs.              
 ;   If the required inputs other than the point have acceptable values,   
 ;   ask for a point but if a number is offered take it as the first       
 ;   and ask for three more, the last being the point.                     
 ;   If any of the required inputs are not acceptable, ask for all of      
 ;   them.                                                                 
 ;   The whole process is intended to be transparent to the user: if the   
 ;   program is called from the menu all arguments are supplied except     
 ;   the point.  The command can be repeated with a <Return> in which      
 ;   case it uses the previous block name and break distance values.       
 ;                                                                         
 ;   Takes no arguments, calls nothing, returns a list: two numbers,       
 ;   intended to be the left and right side break distances, a string      
 ;   (block name) and a point list.                                        
 ;                                                                         
 ; 
 (DEFUN PTOR (/ pa pb)
  (if (and (= (type ldist) 'REAL)
           (= (type rdist) 'REAL)
           (= (type name) 'STR))
      (progn
           (initget 128)
           (setq pa (getpoint "Insertion point: "))
           (if (not (listp pa))
               (progn
                    (setq ldist (* 1.0 (read pa)))
                    (setq rdist (getdist))
                    (setq name (getstring))
                    (setq pa (getpoint)))))
      (progn
           (setq ldist (getdist))
           (setq rdist (getdist))
           (setq name (getstring))
           (setq pa (getpoint "Insertion point: "))))
 ; Ŀ
 ;   See if can snap the insertion point to anything.                      
 ; 
  (setq pb (osnap pa "Nearest"))
  (if pb (setq pa pb))
 (list ldist rdist name pa))
 ; Ŀ
 ;   Ptor end.                                                             
 ; 

 ; Ŀ
 ;   Catsup.                                                               
 ; 
 (DEFUN C:CATSUP (/ *error* scal devlst devls2 pa pb ss typ entt rota attlst
                                            rrota xa xb enam blins blscal pc)
  (setvar "cmdecho" 0)
  (command ".undo" "be")
 ; Ŀ
 ;   Load Misps.lsp, which contains the ps/ms scaling subroutines.         
 ; 
  (if (or (null wasp) (null misps))
      (if (null (load "misps" ()))
          (prompt "\n** The File Misps.lsp Is Not Available. **\n")))
  (setq scal (misps))
 ; Ŀ
 ;   Make a nice local error handler.                                      
 ; 
 (defun *error* (shk)
  (command ".undo" "end")
  (if shk (write-line shk))
 (princ))
 ; Ŀ
 ;   And get a block name and cut distances and insertion point.           
 ; 
  (setq lisa (ptor))
  (setq ldist (car lisa))
  (setq rdist (cadr lisa))
  (setq name (strcase (caddr lisa)))
  (setq pa (cadddr lisa))
  (setq ldisst (* ldist scal))
  (setq rdisst (* rdist scal))
 ; Ŀ
 ;   If there is a line or a pline at the insertion point...               
 ; 
  (if (setq ss (ssget pa))
      (progn
           (setq typ (cdr (assoc 0 (entget (setq enam (ssname ss 0))))))
 ; Ŀ
 ;   Get the angle of the segment containing the pick point.               
 ; 
           (if (or (= typ "LINE") (= typ "POLYLINE") (= typ "LWPOLYLINE"))
               (progn
                    (setq rota (pf pa enam))
                    (setq rota (angle (cadr rota) (caddr rota)))
                    (if (and (> rota (/ pi 2)) (<= rota (* pi 1.5)))
                        (setq rota (+ rota pi)))))))
 ; Ŀ
 ;   Now decide what to do.  The block rotation matches the line           
 ;   rotation, if there is no line then the rotation is 0.                 
 ; 
  (cond ((and (or (= typ "LINE") (= typ "POLYLINE") (= typ "LWPOLYLINE")))
         (setq rrota (/ (* 180 rota) pi))
         (setq xa (polar pa rota rdisst))
         (setq xb (polar pa rota (- ldisst)))
         (command "break" pa "f" xa xb))
        (T (setq rrota 0.0)))
  (if (>= rrota 360) (setq rrota (- rrota 360)))
 ; Ŀ
 ;   Insert the block, ask for attribute values.                           
 ; 
  (command "insert" name pa scal "" rrota)
  (setq prlis (pomm name))     ; after insertion, so block is defined in dwg
  (while (= 1 (getvar "cmdactive"))
         (setq promst (if prlis (car prlis) "Value: "))
         (setq prlis (cdr prlis))
         (setq str (getstring (strcat "\n" promst ": ")))
         (command str))
 ; Ŀ
 ;   Reposition and rejustify the attributes if necessary.                 
 ; 
  (if (equal rrota 90 30)
      (progn
           (setq enam (entlast))
           (setq entt (entget enam))
           (setq blins (cdr (assoc 10 entt)))
           (setq blscal (cdr (assoc 41 entt)))
 ; Ŀ
 ;   Get a list of enames for all attributes in the block.                 
 ; 
           (while (/= (cdr (assoc 0 (entget (setq enam (entnext enam)))))
                      "SEQEND")
                  (setq attlst (cons enam attlst)))
 ; Ŀ
 ;   Reposition attributes based on list length.                           
 ;   If there are two attributes then put the first on the left side of    
 ;   the block and the next on the right.                                  
 ;   If there is only one then put it on the right.                        
 ; 
           (setq len (length attlst))
           (cond ((= len 1)
                  (setq enam (car attlst))
                  (repat enam "ML" (polar blins 0 (* blscal 5)))
                  (entupd enam))
                 ((= len 2)
                  (setq enam (car attlst))
                  (setq pc (polar blins (/ pi 2) (* blscal 5)))
                  (repat enam "R" (polar pc pi (* blscal 5)))
                  (repat (cadr attlst) "L" (polar pc 0 (* blscal 5)))
                  (entupd enam))
                 (T (prompt "\nUnknown block.")))))
 ; Ŀ
 ;   Reset and end.                                                        
 ; 
  (*error* ())
 (princ))